﻿using System;
using System.Linq;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Threading;
using Modbus.Device;
using System.IO.Ports;

namespace NModbusTest
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        ModbusSerialMaster _modbusMaster;
        SerialPort _serialPort;
        const int SLAVE_ADDRESS = 1;

        private void Form1_Load(object sender, EventArgs e)
        {
            // Open COM1 with a baud rate of 115200
            _serialPort = new SerialPort("COM1", 115200);
            _serialPort.Open();

            // Create a new Modbus RTU Master using using _serialPort as the communication channel
            _modbusMaster = ModbusSerialMaster.CreateRtu(_serialPort);
            _modbusMaster.Transport.ReadTimeout = 500;
            _modbusMaster.Transport.WriteTimeout = 500;
            _modbusMaster.Transport.Retries = 0;
        }

        void ReportError(string s)
        {
            // Display a messagebox when reporting errors.
            MessageBox.Show(s);
        }

        private void ReadADC()
        {
            ushort[] result = null;

            // Try to read the ADC value.  The CUBLOC stores the value read from the ADC
            // in register D10. D10 is Modbus address 0x7000A on the CUBLOC.
            // See the CUBLOC Modbus slave source code.
            try
            {
                result = _modbusMaster.ReadInputRegisters(SLAVE_ADDRESS, 0x700A, 1);
            }
            catch (Exception ex)
            {
                ReportError(ex.Message);
            }

            // If we successfully read the value, display the result on the form.
            if (result != null && result.Length > 0)
            {
                _adcLabel.Text = result[0].ToString();
            }
        }

        private void ReadDigitalOutput()
        {
            bool[] result = null;

            // Try to read the digital output value.  The CUBLOC has digital IO mapped to the P
            // area.  P0 is Modbus address 0x0000 on the CUBLOC.  
            // See the CUBLOC Modbus slave source code.
            try
            {
                result = _modbusMaster.ReadCoils(SLAVE_ADDRESS, 0x0000, 1);
            }
            catch (Exception ex)
            {
                ReportError(ex.Message);
            }

            // If we successfully read the value, display the result on the form.
            if (result != null)
            {
                if (result[0])
                {
                    _digitalOutLabel.Text = "ON";
                }
                else
                {
                    _digitalOutLabel.Text = "OFF";
                }
            }
        }

        private void WriteDigitalOutput(bool on)
        {
            // Try to update the digital output value.  The CUBLOC has digital IO mapped to the P
            // area.  P0 is Modbus address 0x0000 on the CUBLOC.
            // See the CUBLOC Modbus slave source code.
            try
            {
                _modbusMaster.WriteSingleCoil(SLAVE_ADDRESS, 0x0000, on);
            }
            catch (Exception ex)
            {
                ReportError(ex.Message);
            }
        }

        private void _digitalOutReadButton_Click(object sender, EventArgs e)
        {
            // Read and display the current state of the digital output
            ReadDigitalOutput();
        }

        private void _onButton_Click(object sender, EventArgs e)
        {
            // Turn the digital output ON
            WriteDigitalOutput(true);
        }

        private void _offButton_Click(object sender, EventArgs e)
        {
            // Turn the digital output OFF
            WriteDigitalOutput(false);
        }

        private void _adcReadButton_Click(object sender, EventArgs e)
        {
            // Read and display the current value of the ADC
            ReadADC();
        }

        private void Form1_Closing(object sender, CancelEventArgs e)
        {
            // clean up and when closing the form
            _modbusMaster.Dispose();
            _modbusMaster = null;

            _serialPort.Close();
            _serialPort.Dispose();
            _serialPort = null;
        }
    }
}